export default function createDefaultPackJson(pack, categories = undefined, settings = undefined, origin = undefined, markers) {
    const { name, author, version, for: forApp } = pack;
    const defaultCategories = [
        {
            "name": "First Cat",
            "path": `D:\\temp\\MotionBro\\${pack.packFolderName}_by_Videolancer\\First Cat`,
            "type": "category",
            "children": [
                {
                    "name": "Footage with Marker",
                    "path": `D:\\temp\\MotionBro\\${pack.packFolderName}_by_Videolancer\\First Cat\\Footage with Marker.mp4`,
                    "preview": `http://localhost:3000/ignore/preview/video/Default video prew 1.mp4`,
                    "type": "mp4"
                },
                {
                    "name": "[Ease in] - Dom",
                    "path": `D:\\temp\\MotionBro\\${pack.packFolderName}_by_Videolancer\\First Cat\\Dom.mp4`,
                    "preview": `http://localhost:3000/ignore/preview/video/Default video prew 1.mp4`,
                    "type": "mp4"
                }
            ]
        },
    ];
    return {
        packName: name || "Default pack name",
        author: author || "VideoLancer",
        version: version || "1.0.0",
        origin: origin,
        apps: forApp || "PP",
        categories: categories || defaultCategories,
        settings: settings,
        markers: markers,
    };
}
